# COMPUTING AND PLOTTING THE INTERVAL USING THE PREVIOUSLY BOOTSTRAPPED VALUES #

library(scales)
library(dplyr)
library(plotrix)
##################
setwd("Pied Flycatcher Phenology/Interval estimation/Interval")
devondata <- read.csv("devon_data.csv", header = TRUE) # empirical data

# Functions for retrieving quantiles
quantx.25 <- function(x) return (quantile(x, probs = 0.25, na.rm = TRUE))
quantx.025 <- function(x) return (quantile(x, probs = 0.025, na.rm = TRUE))
quantx.75 <- function(x) return (quantile(x, probs = 0.75, na.rm = TRUE))
quantx.50 <- function(x) return (quantile(x, probs = 0.50, na.rm = TRUE))
quantx.975 <- function(x) return (quantile(x, probs = .975, na.rm = TRUE))

# Function to add seasonal axis to figures (J, F, M, A, ...)
add_year_axis <- function(){
  month1 <- as.POSIXlt(paste0("2014-",3:7, "-02"))
  day1 <- month1$yday
  month15 <- as.POSIXlt(paste0("2015-", 3:7, "-16"))
  day15 <- month15$yday
  
  #april <- as.POSIXlt(paste0("2014-",4,"-",c(1,7,14,21,28)))
  april <- as.POSIXlt(paste0("2014-",4,"-",c(7,14,21,28)))
  dayapril <- april$yday
  may <- as.POSIXlt(paste0("2014-",5,"-",c(5,12,19,26)))
  daymay <- may$yday
  june <- as.POSIXlt(paste0("2014-",6,"-",c(2,9,16,23,29)))
  dayjune <- june$yday
  
  axis(side=1, at=dayapril, cex.axis = .9,labels=c("7 Apr","14 Apr","21 Apr","28 Apr"))
  axis(side=1, at=daymay, cex.axis = .9, labels=c("5 May","12 May","19 May","26 May"))
  axis(side=1, at=dayjune, cex.axis = .9, labels=c("2 Jun","9 Jun","16 Jun","23 Jun","29 Jun"))
  axis(side = 1, labels = FALSE, lwd.ticks = 0)
  
  Axis(side=2, labels=TRUE, cex.axis = .9)
  
       }
  
#### PLOT ARRIVAL AND BREEDING SEPARATELY ####
par(mfrow=c(4,1), mar=c(3, 4, 2, 2) + 0.1 , mai=c(.1, .5, .1, .1),oma=c(2, 2, 1.5, 1.5))
for (yr in 2013:2016)
    {
      # retrieve "quantiles" for bootstrapped median arrival and laying dates
  
  # middates correspond to the median dates associates with each latitude
  # xxquants correspond to the already computed quantiles for the previous bootstraps
    middatesnrs <- readRDS(file=paste0("median dates/pf_middatesnrs_k4_",yr,".rds"))
    nrsquants <- readRDS(file=paste0("median dates/pf_bootquantnrs_k4_",yr,".rds"))
    middatesbt <- readRDS(file =paste0("median dates/pf_middatesbt_k4_",yr,".rds"))
    btquants <- readRDS(file =paste0("median dates/pf_bootquantbt_k4_",yr,".rds"))
      
    # convert northings from meters to km
    middatesbt$northings <- middatesbt$northings/1000
    middatesnrs$northings <- middatesnrs$northings/1000
    btquants$northings <- btquants$northings/1000
    nrsquants$northings <- nrsquants$northings/1000
    
    # add empty plot
    plot(0, 0, col="white", xlim = c(90,140), ylim = c(50,600), xlab="",
         ylab="Northing (km)", axes = FALSE,xaxs = "i",yaxs="i", main = "")
    # add lines on specific days
    abline(v=c(96, 
               103, 
               110, 
               117, 
               124, 
               131, 
               138, 
               145), lty=1, col="gray75", cex=.6)
    
    Axis(side=2, labels=TRUE, cex.axis = .9)
    
    # ONLY ADD AXIS AT THE LAST PLOT
    if(yr == 2016){add_year_axis()}
    
    # PLOTTING ARRIVAL #
    # 95% bootstrap interval
    polygon(c(btquants[,4], rev(btquants[,2])),c(middatesbt[,1], rev(middatesbt[,1])),
            col = alpha("red2",0.5), border = NA)
    # each bootstrap
    for(i in 2:ncol(middatesbt)) lines(middatesbt[,i],middatesbt[,1], col = alpha("gray10",0.15), lwd = 1)
    # median line
    lines(btquants[,3],btquants[,1], col = alpha("white",1), lwd = 2, lty = 3)
    
    # PLOTTING BREEDING #
    # 95% bootstrap interval
    polygon(c(nrsquants[,4], rev(nrsquants[,2])),c(middatesnrs[,1], rev(middatesnrs[,1])),
            col = alpha("blue2",0.5), border = NA)
    # each bootstrap
    for(i in 2:ncol(middatesnrs)) lines(middatesnrs[,i],middatesnrs[,1], col = alpha("gray20",0.05), lwd = 1)
    # median line
    lines(nrsquants[,3],nrsquants[,1],  col = alpha("white",1), lwd = 2, lty = 3)
    
    legend(88,600, legend=c(yr), bty="n", text.font = 2, cex=1.5)
    
    
}


#### ARRIVAL-BREEDING INTERVAL PLOT ####

par(mfrow=c(1,4), mar=c(5, 1, 2, 2) + 0.1 , mai=c(.6, .1, .2, .1),oma=c(.5, 4, 1.5, 1.5))
for (yr in 2013:2016)
  
  
{
  # read in bootstraps for arrival and breeding, and quantiles
  middatesnrs <- readRDS(file=paste0("median dates/pf_middatesnrs_",k.nrs,"_",yr,".rds"))
  nrsquants <- readRDS(file=paste0("median dates/pf_bootquantnrs_",k.nrs,"_",yr,".rds"))
  middatesbt <- readRDS(file =paste0("median dates/pf_middatesbt_",k.bt,"_",yr,".rds"))
  btquants <- readRDS(file =paste0("median dates/pf_bootquantbt_",k.bt,"_",yr,".rds"))
  
  # meters to km
  middatesbt$northings <- middatesbt$northings/1000
  middatesnrs$northings <- middatesnrs$northings/1000
  btquants$northings <- btquants$northings/1000
  nrsquants$northings <- nrsquants$northings/1000
  
  # aggregate values every 10 km
  middatesbt$roundnorth <- floor(middatesbt$northings/10)*10
  newxbt <- aggregate(select(middatesbt, -c(northings, roundnorth)), by = list(northings = middatesbt$roundnorth), FUN = median)
  
  # obtain minimum and maximum northings for both arrival and breeding
  minN <- max(min(newxbt$northings),min(middatesnrs$northings))
  maxN <- min(max(middatesnrs$northings),max(newxbt$northings))
  
  # remove edges, making sure arrival and breeding northings are comparable
  newbt <- newxbt[which(newxbt$northings==minN):which(newxbt$northings==maxN),]
  newnrs <- middatesnrs[which(middatesnrs$northings==minN):which(middatesnrs$northings==maxN),]
  
  # compute the arrival breeding interval
  gap <- newnrs-newbt
  gap$northings <- newbt$northings
  
  # retrieve the quantiles
  gap_q <- data.frame(northings = gap[,1],
                      quant.025 = apply(gap[,-1], 1, FUN = quantx.025),
                      quant.50 = apply(gap[,-1], 1, FUN = quantx.50),
                      quant.975 = apply(gap[,-1], 1, FUN = quantx.975))
  
  mn <- ifelse(yr==2013,"Interval (Days)","")
  
  # initiate plot
  plot(0, 0, col="white", xlim=c(60,600), ylim=c(0,35), xlab="Northing (km)",
      ylab=mn,
       axes = FALSE,xaxs = "i",yaxs="i",yaxt = "n")
  # if it is the first, add y lab
  if(yr==2013) mtext(side=2, line=3, "Arrival-laying Interval (Days)", col="black", font=1, cex=.7)

  #  for better comparison
  abline(h=c(seq(5,35,5)), lty=1, col="gray80", cex=.6)
  
  Axis(side=1, labels=TRUE, cex.axis = .9)
  
  # add axis on the left
  if(yr==2013) Axis(side=2, labels=TRUE, cex.axis = .9)
  
  # plot 95% confidence intervals
  polygon(c(gap[,1], rev(gap[,1])), c(gap_q[,4], rev(gap_q[,2])),
          col = alpha("purple3",0.5), border = NA)
  
  for(i in 2:ncol(gap)) lines(gap[,1],gap[,i], col = alpha("gray20",0.15), lwd = 1)
  lines(gap_q[,1],gap_q[,3], col = alpha("white",1), lwd = 2, lty = 3)
  
  ### EMPIRICAL DATA FROM DEVON in 2015-16 ###
  devdat <- filter(devondata, year == yr)
  
  x<-devdat$gap
  # confidence interval for the median using the binomial distribution (Conover, 1999)
  qmedian <- sort(x)[qbinom(c(.025,.975), length(x), 0.5)]
  # plot confidence intervals for the empirical data
  plotrix :: plotCI(devdat$northing[1]/1000,median(devdat$gap),median(devdat$gap)-qmedian[1],qmedian[2]-median(devdat$gap),
                    pch = 18, cex = 3, col = alpha("yellow", 1),add = TRUE)
  
  legend(350,4, legend=c(yr), bty="n", text.font = 2, cex=1.5)
  
}

